-- @Function:Utiles
-- =======================================================================
function RDM_GetAllColonists() return UICity.labels.Colonist end
function RDM_GetAllBuildings(label) return UICity.labels[label] end

-- @Function:Table resources
-- =======================================================================
function Update_ResourcesDropDownListItems(ResourcesList)
	for i, desc in ipairs(ResourcesList) do
		Resources[desc.name] = desc
		if ResourcesDropDownListItems then
			table.insert_unique(ResourcesDropDownListItems, { value = desc.name, text = desc.display_name })
		end
	end
end

function Update_StockpileResourceList(ResourcesList)
	for i, resource in ipairs(ResourcesList) do
		table.insert_unique(StockpileResourceList, resource)
	end
end

function Update_AllResourcesList(ResourcesList)
	for _,categoryName in ipairs(ResourcesList) do
		local list = _G[categoryName.."ResourceList"]
		for _,resource in ipairs(list) do
			table.insert_unique(AllResourcesList, resource)
		end
	end
end

function Update_SubSurfaceDeposits(DepositList)
	for i=1,#DepositList do
		SubSurfaceDeposits[DepositList[i]] = true
	end
end

-- @Function:FormatResourceFn
-- =======================================================================
local rs = const.ResourceScale
local ForcedIntegerResources = {
	["Policy"] = true,
}

local function GetFracWithoutEndingZeros(frac)
	while frac % 10 == 0 do
		frac = frac/10
	end
	return tostring(frac)
end

local function GetFracOfZeroInt(value, resource)
	local frac
	if value<(rs/100) then
		if ResourceNoRoundingDecimalPart[resource] then
			frac = Untranslated("00".. GetFracWithoutEndingZeros(value%rs))
		else
			if value >= rs/200 then
				frac = Untranslated("01")
			end
		end
	elseif value<(rs/10) then
		if ResourceNoRoundingDecimalPart[resource] then
			frac = Untranslated("0".. GetFracWithoutEndingZeros(MulDivRound(value, 100, 10)/10))
		else
			if value >= rs/10 - rs/200 then
				frac = Untranslated("1")
			else
				frac = Untranslated("0".. tostring(value%(rs/100) < rs/200 and value/(rs/100) or value/(rs/100) + 1))
			end
		end
	elseif value<rs and ResourceNoRoundingDecimalPart[resource] then
		frac = Untranslated(GetFracWithoutEndingZeros(value))
	end
	return frac
end

function FV_FormatResourceValueMaxResource(context_obj, value, max, resource)
	if not value then return "" end
	
	local value_sign = value ~= 0 and abs(value)/value or 1
	value = abs(value)
	local value_frac = MulDivRound(value, 10, rs) % 10
	local value_int = MulDivRound(value, 10, rs)/10
	
	if not resource then
		-- three arguments or less
		if max then
			resource = max
		end
		max = false
	end
	if resource == "funding" then
		return TFormat.funding(context_obj, value)
	end
	
	local force_integer = ForcedIntegerResources[resource]
	local Tmax, Tresource = "", ""
	
	if max then
		local max_frac = MulDivRound(max, 10, rs) % 10
		if force_integer then
			Tmax  = T{4842, "/<int>", int = max} 
		else
			local max_int = MulDivRound(max, 10, rs)/10
			Tmax  = max_frac == 0 and T{4842, "/<int>", int = max_int} or T{4843, "/<int>.<frac>", int = max_int, frac = max_frac }
		end
	end

	if resource then
		Tresource = TLookupTag("<icon_" .. resource .. ">")
	end

	local frac 
	if value ~= 0 and value_int == 0 then
		frac = GetFracOfZeroInt(value, resource)
	end
	local Tvalue = force_integer and T{4844, "<int>", int = value} 
		or (value_frac == 0 and not frac) and T{4844, "<int>", int = value_int} 
		or T{4845, "<int>.<frac>", int = value_int, frac = frac or Untranslated(value_frac) } 
	if value_sign < 0 then
		Tvalue = T(6981, "-") .. Tvalue
	end
	return Tvalue .. Tmax .. Tresource
end

function FV_FormatResourceFn(format_id, resource)
	if resource ~= "Research" then
		FormattableResourcesWithoutRP[#FormattableResourcesWithoutRP + 1] = { text = resource, value = format_id }
	end
	FormattableResources[#FormattableResources + 1] = { text = resource, value = format_id }
	TFormat[format_id] = function(context_obj, value, max)
		return FV_FormatResourceValueMaxResource(context_obj, value, max, resource)
	end
end

